/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.networking;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import tallestred.piglinproliferation.networking.ServerToClientPacketStuff;

public class AlchemistBeltSyncPacket {
    final int slotId;
    final ItemStack stack;
    private final int entityId;

    public AlchemistBeltSyncPacket(int entityId, int slotID, ItemStack stack) {
        this.entityId = entityId;
        this.slotId = slotID;
        this.stack = stack;
    }

    public static AlchemistBeltSyncPacket decode(FriendlyByteBuf buf) {
        return new AlchemistBeltSyncPacket(buf.readInt(), buf.readInt(), buf.m_130267_());
    }

    public static void encode(AlchemistBeltSyncPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.slotId);
        buf.m_130055_(msg.stack);
    }

    public static void handle(AlchemistBeltSyncPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ServerToClientPacketStuff.syncBelt(msg));
        context.get().setPacketHandled(true);
    }

    public int getEntityId() {
        return this.entityId;
    }
}

